//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Check of certificate validity 
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CMP_RA_CERT "cmp_ra.cer"
//------------------------------------------------------------------------------
unsigned char Cert[8196];
//------------------------------------------------------------------------------
// :
// 1.   
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY  hKey =0;
 DWORD len,sz;
 char vfr[32],vto[32],cur[32];

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   
 if (getFileLen(CMP_RA_CERT,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_RA_CERT,Cert,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 
// if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //   
 if (!CPImportKey(hProv,Cert,sz,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    
 len=sizeof(vfr);
 if (!CPGetKeyParam(hProv,hKey,KP_CRT_VFROM,(BYTE*)vfr,&len,0)) {
   printf("CPGetKeyParam KP_CRT_VFROM Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 vfr[len]=0;
 len=sizeof(vto);
 if (!CPGetKeyParam(hProv,hKey,KP_CRT_VTO,(BYTE*)vto,&len,0)) {
   printf("CPGetKeyParam KP_CRT_VTO Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 vto[len]=0;
 //   
 len=sizeof(cur);
 if (!CPGetProvParam(hProv,PP_SYS_TIME,(BYTE*)cur,&len,0)) {
   printf("CPGetProvParam(PP_SYS_TIME) Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 cur[len]=0;
 //  
 code=memcmp(vfr,cur,14); if (code>0) {printf("Error Validity FROM\r\n"); return 1;}
 code=memcmp(vto,cur,14); if (code<0) {printf("Error Validity TO\r\n");   return 1;}
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
